/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.cpp11

import com.google.inject.Inject
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp11.Cpp11Naming
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sctunit.generator.cpp.extensions.CppMockingExtensions
import com.yakindu.sctunit.generator.cpp.extensions.SCTUnitCppNaming
import com.yakindu.sctunit.sCTUnit.SCTUnitClass

/**
 * Cpp11 specific mock object creation (declaring vaiable in SCTUnit) 
 * 
 * @author laszlo kovacs- Initial contribution.
 */
class Cpp11MockingExtensions extends CppMockingExtensions{
	@Inject extension SExecExtensions
	@Inject extension Cpp11Naming
	@Inject protected extension SCTUnitCppNaming
	@Inject protected extension CppPointers
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected GeneratorEntry entry
	
	override defineInterfaceMockObjects(SCTUnitClass clazz){	
		if (entry.usePlainOperationCallbackPointers) {
			return super.defineInterfaceMockObjects(clazz)
		}
			
		val allScopes = clazz.statechart.scopes.filter(InterfaceScope) + clazz.statechart.scopes.filter(InternalScope)
		'''
		«FOR sc: allScopes»
			«IF sc !== null && !sc.members.filter(OperationDefinition).nullOrEmpty»
				«sharedPtr»«sc.mockClassName»«pointerType» «sc.mockObjectName»;
			«ENDIF»	
		«ENDFOR»
		'''
	}
	
	override setupInterfaceMockInstances(SCTUnitClass clazz){
		if (entry.usePlainOperationCallbackPointers) {
			return super.setupInterfaceMockInstances(clazz)
		}

		val allScopes = clazz.statechart.scopes.filter(InterfaceScope) + clazz.statechart.scopes.filter(InternalScope)
		'''
		«FOR sc: allScopes»
			«IF sc !== null && !sc.members.filter(OperationDefinition).nullOrEmpty»
				«sc.mockObjectName» = «makeSharedPtr»«sc.mockClassName»«makeTypeCloser»(this);
			«ENDIF»	
		«ENDFOR»
		'''
	}
	
	override tearDownInterfaceMockInstances(SCTUnitClass clazz){
		if (entry.usePlainOperationCallbackPointers) {
			return super.tearDownInterfaceMockInstances(clazz)
		}
		val allScopes = clazz.statechart.scopes.filter(InterfaceScope) + clazz.statechart.scopes.filter(InternalScope)
		'''
		«FOR sc: allScopes»
			«IF sc !== null && !sc.members.filter(OperationDefinition).nullOrEmpty»
				«sc.mockObjectName».reset();
			«ENDIF»	
		«ENDFOR»
		'''
	}
	
}